//
//  GDTSDKStartViewController.m
//  GDTMobApp
//
//  Created by chenjunru on 2025/5/30.
//  Copyright © 2025 Tencent. All rights reserved.
//

#import "GDTSDKStartViewController.h"

static CGFloat const kStartViewButtonHeight = 80.0;
static CGFloat const kStartViewButtonWidth  = 280.0;

@interface GDTSDKStartViewController ()

@property (nonatomic, strong) UIButton *startButton;
@property (nonatomic, strong) UIButton *enterButton;
@property (nonatomic, assign) BOOL alreadyInitialized;

@end

@implementation GDTSDKStartViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    self.view.backgroundColor = UIColor.whiteColor;
    
    self.startButton.frame = CGRectMake((self.view.bounds.size.width - kStartViewButtonWidth) / 2.0, (self.view.bounds.size.height - kStartViewButtonHeight) / 2.5, kStartViewButtonWidth, kStartViewButtonHeight);
    [self.view addSubview:self.startButton];
    
    self.enterButton.frame = CGRectMake((self.view.bounds.size.width - kStartViewButtonWidth) / 2.0, 1.5 * (self.view.bounds.size.height - kStartViewButtonHeight) / 2.5, kStartViewButtonWidth, kStartViewButtonHeight);
    [self.view addSubview:self.enterButton];
}

- (UIButton *)createButtonWithTitle:(NSString *)title action:(SEL)action {
    UIButton *button = [UIButton buttonWithType:UIButtonTypeSystem];
    button.layer.borderWidth = 1.5;
    button.layer.cornerRadius = kStartViewButtonHeight / 2.0;
    button.layer.masksToBounds = YES;
    button.backgroundColor = UIColor.whiteColor;
    button.layer.borderColor = UIColor.blueColor.CGColor;
    [button setTitle:title forState:UIControlStateNormal];
    button.titleLabel.font = [UIFont systemFontOfSize:26.0 weight:UIFontWeightSemibold];
    [button setTitleColor:UIColor.blackColor forState:UIControlStateNormal];
    [button addTarget:self action:action forControlEvents:UIControlEventTouchUpInside];
    return button;
}

- (void)clickStartButton {
    if (self.alreadyInitialized) {
        [self showToast:@"您已经初始化过了"];
        return;
    }
    [self showToast:@"初始化成功"];
    self.alreadyInitialized = YES;
    if (self.clickStartBlock) {
        self.clickStartBlock();
    }
}

- (void)clickEnterButton {
    if (!self.alreadyInitialized) {
        [self showToast:@"还没初始化SDK，请先进行初始化"];
        return;
    }
    if (self.clickEnterBlock) {
        self.clickEnterBlock();
    }
}

- (UIButton *)startButton {
    if (!_startButton) {
        _startButton = [self createButtonWithTitle:@"第一步：初始化SDK" action:@selector(clickStartButton)];
    }
    return _startButton;
}

- (UIButton *)enterButton {
    if (!_enterButton) {
        _enterButton = [self createButtonWithTitle:@"第二步：开始展示广告" action:@selector(clickEnterButton)];
    }
    return _enterButton;
}

- (void)showToast:(NSString *)toast {
    UIView *backView = [[UIView alloc] init];
    backView.backgroundColor = [UIColor colorWithRed:0 green:0 blue:0 alpha:1];
    backView.layer.cornerRadius = 8;
    backView.layer.masksToBounds = YES;
    backView.translatesAutoresizingMaskIntoConstraints = NO;
    backView.alpha = 0;
    backView.layer.zPosition = 10;
    backView.userInteractionEnabled = NO;

    UILabel *toastLabel = [[UILabel alloc] init];
    toastLabel.text = toast;
    toastLabel.font = [UIFont systemFontOfSize:14];
    toastLabel.textColor = [UIColor whiteColor];
    toastLabel.textAlignment = NSTextAlignmentCenter;
    [toastLabel sizeToFit];
    toastLabel.translatesAutoresizingMaskIntoConstraints = NO;
    
    [backView addSubview:toastLabel];
    [self.view addSubview:backView];
    
    [backView addConstraint:[NSLayoutConstraint constraintWithItem:toastLabel attribute:NSLayoutAttributeCenterY relatedBy:NSLayoutRelationEqual toItem:backView attribute:NSLayoutAttributeCenterY multiplier:1 constant:0]];
    [backView addConstraint:[NSLayoutConstraint constraintWithItem:toastLabel attribute:NSLayoutAttributeCenterX relatedBy:NSLayoutRelationEqual toItem:backView attribute:NSLayoutAttributeCenterX multiplier:1 constant:0]];
    [self.view addConstraint:[NSLayoutConstraint constraintWithItem:backView attribute:NSLayoutAttributeCenterY relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeCenterY multiplier:1 constant:0]];
    [self.view addConstraint:[NSLayoutConstraint constraintWithItem:backView attribute:NSLayoutAttributeCenterX relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeCenterX multiplier:1 constant:0]];
    [self.view addConstraint:[NSLayoutConstraint constraintWithItem:backView attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:toastLabel attribute:NSLayoutAttributeWidth multiplier:1 constant:20]];
    [self.view addConstraint:[NSLayoutConstraint constraintWithItem:backView attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:toastLabel attribute:NSLayoutAttributeHeight multiplier:1 constant:20]];
    
    [UIView animateWithDuration:0.3 animations:^{
        backView.alpha = 1;
    } completion:^(BOOL finished) {
        [UIView animateWithDuration:0.3 delay:1 options:0 animations:^{
            backView.alpha = 0;
        } completion:^(BOOL finished) {
            [backView removeFromSuperview];
        }];
    }];
}

@end
